﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;
using VistATool.Utils;

namespace VistATool.Controllers
{
    /// <summary>
    /// 
    /// </summary>
    public class DischargeWorkflowController : Controller
    {

        // GET: /Discharge/

        public ActionResult Index()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                List<WorkflowViewModel> viewModelList = new List<WorkflowViewModel>();

                WorkflowViewModel viewModel = new WorkflowViewModel();

                IList<CPRS_ORDERS> listOrders = db.CPRS_ORDERS.OrderBy(a => a.OBJECT_OF_ORDER).ToList();

                foreach (PATIENT_APPOINTMENT app in db.PATIENT_APPOINTMENT.ToList())
                {
                    app.HOSPITAL_LOCATION = db.HOSPITAL_LOCATION.Find(app.HOSPITAL_LOCATION_ID);
                    app.PATIENT = db.PATIENTs.Find(app.PATIENT_ID);
                    viewModel.PatientAppointment = app;

                    viewModel.CPRSOrder = listOrders.Where(a => a.OBJECT_OF_ORDER == app.PATIENT.NAME && IsDischarge(a) && a.INTERNAL_UID == app.INTERNAL_UID).FirstOrDefault();
                    if (viewModel.CPRSOrder != null)
                    {
                        viewModel.CPRSOrder.ORDER_STATUS = db.ORDER_STATUS.Find(viewModel.CPRSOrder.ORDER_STATUS_ID);

                        viewModel.OrderAction = viewModel.CPRSOrder.ORDER_ACTIONS;
                        viewModel.OrderAction.NEW_PERSON1 = db.NEW_PERSON.Find(viewModel.OrderAction.SIGNED_BY_ID);
                        viewModel.OrderAction.NEW_PERSON2 = db.NEW_PERSON.Find(viewModel.OrderAction.PROVIDER_ID);

                        viewModel.PatientMovement = app.PATIENT.PATIENT_MOVEMENT.Where(a => a.TRANSACTION_ == "3" && a.INTERNAL_UID == viewModel.CPRSOrder.INTERNAL_UID).ToList().FirstOrDefault();
                        if (viewModel.PatientMovement != null)
                        {

                            viewModel.PatientMovement.NEW_PERSON = db.NEW_PERSON.Find(viewModel.PatientMovement.ENTERED_BY_ID);
                            viewModel.PatientMovement.TYPE_OF_MOVEMENT = db.TYPE_OF_MOVEMENT.Find(viewModel.PatientMovement.TYPE_OF_MOVEMENT_ID);

                            viewModel.PatientMovement.WARD_LOCATION = db.WARD_LOCATION.Find(viewModel.PatientMovement.WARD_LOCATION_ID);
                            viewModel.PatientMovement.ROOM_BED = db.ROOM_BED.Find(viewModel.PatientMovement.ROOM_BED_ID);
                        }
                    }
                    viewModelList.Add(viewModel);
                    viewModel = new WorkflowViewModel();
                }
                return View(viewModelList);
            }
        }

        //GET
        public ActionResult Create()
        {
            WorkflowViewModel wf = new WorkflowViewModel();
            FillModel(wf);
            wf.InternalUid = Guid.NewGuid().ToString();
            wf.IsEnabledPatientAppointment = true;
            wf.IsEnabledOrder = false;
            wf.IsEnabledEvent = false;
            return View(wf);
        }

        [HttpPost]
        public ActionResult Create(WorkflowViewModel viewModel, string btnSaveDischargeIntent, string btnSaveOrder, string btnSavePatientMovement)
        {
            bool IsSaved = false;


            if (viewModel.FillBeds != null || viewModel.FillWards != null)
            {
                FillModel(viewModel);
                return View(viewModel);
            }
            try
            {
                if (viewModel.PatientAppointment.PATIENT_ID == 0)
                    ModelState.AddModelError("Patient", "The PATIENT NAME field is required.");
                else
                    using (var db = new BMS_VISTA_DBEntities())
                    {
                        //create Discharge Intent
                        if (!string.IsNullOrEmpty(btnSaveDischargeIntent))
                        {
                            viewModel.PatientAppointment.INTERNAL_UID = Guid.Parse(viewModel.InternalUid);
                            if (viewModel.PatientAppointment.IEN == 0)
                                db.Entry(viewModel.PatientAppointment).State = System.Data.EntityState.Added;
                            else
                                db.Entry(viewModel.PatientAppointment).State = System.Data.EntityState.Modified;

                            double value = 0;
                            if (viewModel.PatientAppointment.APPOINTMENT_DATETIME != null && double.TryParse(viewModel.PatientAppointment.APPOINTMENT_HOUR, out value))
                                viewModel.PatientAppointment.APPOINTMENT_DATETIME = viewModel.PatientAppointment.APPOINTMENT_DATETIME.AddHours(value);

                            if (viewModel.PatientAppointment.APPOINTMENT_DATETIME != null && double.TryParse(viewModel.PatientAppointment.APPOINTMENT_MINUTE, out value))
                                viewModel.PatientAppointment.APPOINTMENT_DATETIME = viewModel.PatientAppointment.APPOINTMENT_DATETIME.AddMinutes(value);

                            if (viewModel.PatientAppointment.DATE_APPOINTMENT_MADE != null && double.TryParse(viewModel.PatientAppointment.DATE_APPOINTMENT_MADE_HOUR, out value))
                                viewModel.PatientAppointment.DATE_APPOINTMENT_MADE = viewModel.PatientAppointment.DATE_APPOINTMENT_MADE.AddHours(value);

                            if (viewModel.PatientAppointment.DATE_APPOINTMENT_MADE != null && double.TryParse(viewModel.PatientAppointment.DATE_APPOINTMENT_MADE_MINUTE, out value))
                                viewModel.PatientAppointment.DATE_APPOINTMENT_MADE = viewModel.PatientAppointment.DATE_APPOINTMENT_MADE.AddMinutes(value);                            
                        }

                        //create Discharge Order
                        if (!string.IsNullOrEmpty(btnSaveOrder))
                        {
                            viewModel.CPRSOrder.OBJECT_OF_ORDER = db.PATIENTs.Find(viewModel.PatientAppointment.PATIENT_ID).NAME;
                            viewModel.CPRSOrder.INTERNAL_UID = Guid.Parse(viewModel.InternalUid);
                            if (viewModel.CPRSOrder.IEN == 0)
                            {
                                if (viewModel.CPRSOrder.ORDERABLE_ITEM_ID == null)
                                {
                                    FillModel(viewModel);
                                    return View(viewModel);
                                }
                                ORDERABLE_ITEM orderableItem = db.ORDERABLE_ITEM.Where(a => a.IEN == viewModel.CPRSOrder.ORDERABLE_ITEM_ID.Value).FirstOrDefault();
                                viewModel.CPRSOrder.ORDERABLE_ITEM1.Add(orderableItem);
                                orderableItem.CPRS_ORDERS.Add(viewModel.CPRSOrder);
                                viewModel.OrderAction.CPRS_ORDERS = viewModel.CPRSOrder;
                                viewModel.OrderAction.DATE_TIME_ORDERED = DateTime.Now;

                                double value = 0;
                                if (viewModel.OrderAction.DATE_TIME_SIGNED != null && double.TryParse(viewModel.OrderAction.HourSelected, out value))
                                    viewModel.OrderAction.DATE_TIME_SIGNED = viewModel.OrderAction.DATE_TIME_SIGNED.Value.AddHours(value);

                                if (viewModel.OrderAction.DATE_TIME_SIGNED != null && double.TryParse(viewModel.OrderAction.MinuteSelected, out value))
                                    viewModel.OrderAction.DATE_TIME_SIGNED = viewModel.OrderAction.DATE_TIME_SIGNED.Value.AddMinutes(value);

                                if (viewModel.CPRSOrder.START_DATE != null && double.TryParse(viewModel.CPRSOrder.START_DATE_HOUR, out value))
                                    viewModel.CPRSOrder.START_DATE = viewModel.CPRSOrder.START_DATE.Value.AddHours(value);

                                if (viewModel.CPRSOrder.START_DATE != null && double.TryParse(viewModel.CPRSOrder.START_DATE_MINUTE, out value))
                                    viewModel.CPRSOrder.START_DATE = viewModel.CPRSOrder.START_DATE.Value.AddMinutes(value);

                                if (viewModel.OrderAction.RELEASE_DATE_TIME != null && double.TryParse(viewModel.OrderAction.RELEASE_HOUR, out value))
                                    viewModel.OrderAction.RELEASE_DATE_TIME = viewModel.OrderAction.RELEASE_DATE_TIME.Value.AddHours(value);

                                if (viewModel.OrderAction.RELEASE_DATE_TIME != null && double.TryParse(viewModel.OrderAction.RELEASE_MINUTE, out value))
                                    viewModel.OrderAction.RELEASE_DATE_TIME = viewModel.OrderAction.RELEASE_DATE_TIME.Value.AddMinutes(value);

                                db.ORDER_ACTIONS.Add(viewModel.OrderAction);
                            }
                            else
                            {
                                db.Entry(viewModel.CPRSOrder).State = System.Data.EntityState.Modified;
                                db.Entry(viewModel.OrderAction).State = System.Data.EntityState.Modified;
                            }
                        }

                        //create Discharge Event
                        if (!string.IsNullOrEmpty(btnSavePatientMovement))
                        {
                            if (viewModel.CPRSOrder.IEN == 0)
                            {
                                ModelState.AddModelError("MessageIfUserWhatdToCreateEventBeforeRequest", "Create Discharge Order and then Discharge Event");
                                FillModel(viewModel);
                                return View(viewModel);
                            }
                            else
                            {
                                if (viewModel.PatientMovement.ROOM_BED_ID == 0)
                                {
                                    ModelState.AddModelError("PatientMovement.ROOM_BED_ID", "The BED field is required.");
                                    FillModel(viewModel);
                                    return View(viewModel);
                                }
                                if (viewModel.PatientMovement.WARD_LOCATION_ID == 0)
                                {
                                    ModelState.AddModelError("PatientMovement.WARD_LOCATION_ID", "The WARD LOCATION field is required.");
                                    FillModel(viewModel);
                                    return View(viewModel);
                                }

                                if (viewModel.PatientMovement.TYPE_OF_MOVEMENT_ID == 0)
                                {
                                    ModelState.AddModelError("PatientMovement.TYPE_OF_MOVEMENT_ID", "The TYPE OF MOVEMENT field is required.");
                                    FillModel(viewModel);
                                    return View(viewModel);
                                }

                                viewModel.PatientMovement.PATIENT_ID = viewModel.PatientAppointment.PATIENT_ID;
                                viewModel.PatientMovement.ENTERED_ON_DATETIME = DateTime.Now;
                                viewModel.PatientMovement.TRANSACTION_ = "3";
                                viewModel.PatientMovement.INTERNAL_UID = Guid.Parse(viewModel.InternalUid);
                                if (viewModel.PatientMovement.IEN == 0)
                                    db.Entry(viewModel.PatientMovement).State = System.Data.EntityState.Added;
                                else
                                    db.Entry(viewModel.PatientMovement).State = System.Data.EntityState.Modified;

                                double value = 0;
                                if (viewModel.PatientMovement.DATETIME != null && double.TryParse(viewModel.PatientMovement.DATETIME_HOUR, out value))
                                    viewModel.PatientMovement.DATETIME = viewModel.PatientMovement.DATETIME.Value.AddHours(value);

                                if (viewModel.PatientMovement.DATETIME != null && double.TryParse(viewModel.PatientMovement.DATETIME_MINUTE, out value))
                                    viewModel.PatientMovement.DATETIME = viewModel.PatientMovement.DATETIME.Value.AddMinutes(value);
                            }
                        }

                        db.SaveChanges();
                        IsSaved = true;
                        ModelState.Clear();
                    }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
                IsSaved = false;
            }
            if (!string.IsNullOrEmpty(btnSaveDischargeIntent))
            {
                if (!IsSaved)
                {
                    viewModel.IsEnabledPatientAppointment = true;
                    viewModel.IsEnabledOrder = false;
                    viewModel.IsEnabledEvent = false;
                }
                else
                {
                    viewModel.IsEnabledPatientAppointment = false;
                    viewModel.IsEnabledOrder = true;
                    viewModel.IsEnabledEvent = false;
                }
            }
            if (!string.IsNullOrEmpty(btnSaveOrder))
            {
                if (!IsSaved)
                {
                    viewModel.IsEnabledOrder = true;
                    viewModel.IsEnabledEvent = false;
                    viewModel.IsEnabledPatientAppointment = false;
                }
                else
                {
                    viewModel.IsEnabledOrder = false;
                    viewModel.IsEnabledPatientAppointment = false;
                    viewModel.IsEnabledEvent = true;
                }
            }

            if (!string.IsNullOrEmpty(btnSavePatientMovement))
            {
                if (!IsSaved)
                {
                    viewModel.IsEnabledPatientAppointment = false;
                    viewModel.IsEnabledOrder = false;
                    viewModel.IsEnabledEvent = true;
                }
                else
                {
                    viewModel.IsEnabledPatientAppointment = false;
                    viewModel.IsEnabledOrder = false;
                    viewModel.IsEnabledEvent = false;
                }
            }

            FillModel(viewModel);
            return View(viewModel);
        }

        private static bool IsDischarge(CPRS_ORDERS value)
        {
            return IsDischarge(value.ORDERABLE_ITEM);
        }

        private static bool IsDischarge(ORDERABLE_ITEM value)
        {
            return value.NAME.Contains(Constants.Discharge, StringComparison.OrdinalIgnoreCase);
        }


        private void FillModel(WorkflowViewModel viewModel)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                if (viewModel.PatientAppointment == null)
                {
                    viewModel.PatientAppointment = new PATIENT_APPOINTMENT();
                    viewModel.PatientAppointment.APPOINTMENT_DATETIME = DateTime.Now;
                    viewModel.PatientAppointment.APPOINTMENT_HOUR = DateTime.Now.Hour.ToString();
                    viewModel.PatientAppointment.APPOINTMENT_MINUTE = DateTime.Now.Minute.ToString();

                    viewModel.PatientAppointment.DATE_APPOINTMENT_MADE = DateTime.Now;
                    viewModel.PatientAppointment.DATE_APPOINTMENT_MADE_HOUR = DateTime.Now.Hour.ToString();
                    viewModel.PatientAppointment.DATE_APPOINTMENT_MADE_MINUTE = DateTime.Now.Minute.ToString();
                }
                viewModel.OrderableItems = db.ORDERABLE_ITEM.OrderBy(a => a.NAME).ToList().Where(IsDischarge).ToList();
                viewModel.Patients = db.PATIENTs.OrderByDescending(a => a.IEN).ToList();
                viewModel.Facilities = db.HOSPITAL_LOCATION.OrderBy(a => a.NAME).ToList();
                viewModel.OrderStatus = db.ORDER_STATUS.ToList();
                viewModel.Persons = db.NEW_PERSON.OrderBy(a => a.NAME).ToList();
                viewModel.Movements = db.TYPE_OF_MOVEMENT.OrderBy(a => a.NAME).ToList();

                //if (viewModel.SelectedPatientIen != 0)
                //    viewModel.SelectedPatient = db.PATIENTs.Find(viewModel.SelectedPatientIen);

                //if (viewModel.SelectedHospitalLocationIen != 0)
                //    viewModel.SelectedPatient = db.HOSPITAL_LOCATION.Find(viewModel.SelectedHospitalLocationIen);

                if (viewModel.CPRSOrder == null)
                {
                    viewModel.CPRSOrder = new CPRS_ORDERS();
                    viewModel.CPRSOrder.START_DATE = DateTime.Now;
                    viewModel.CPRSOrder.START_DATE_HOUR = DateTime.Now.Hour.ToString();
                    viewModel.CPRSOrder.START_DATE_MINUTE = DateTime.Now.Minute.ToString();
                }

                if (viewModel.OrderAction == null)
                {
                    viewModel.OrderAction = new ORDER_ACTIONS();
                    viewModel.OrderAction.RELEASE_DATE_TIME = DateTime.Now;
                    viewModel.OrderAction.RELEASE_HOUR = DateTime.Now.Hour.ToString();
                    viewModel.OrderAction.RELEASE_MINUTE = DateTime.Now.Minute.ToString();

                    viewModel.OrderAction.DATE_TIME_SIGNED = DateTime.Now;
                    viewModel.OrderAction.HourSelected = DateTime.Now.Hour.ToString();
                    viewModel.OrderAction.MinuteSelected = DateTime.Now.Minute.ToString();
                }

                if (viewModel.PatientMovement == null)
                {
                    viewModel.PatientMovement = new PATIENT_MOVEMENT();
                    viewModel.PatientMovement.DATETIME = DateTime.Now;
                    viewModel.PatientMovement.DATETIME_HOUR = DateTime.Now.Hour.ToString();
                    viewModel.PatientMovement.DATETIME_MINUTE = DateTime.Now.Minute.ToString();
                }

                viewModel.Wards = db.WARD_LOCATION.Where(a => a.HOSPITAL_LOCATION_ID == viewModel.CPRSOrder.PATIENT_LOCATION_ID).OrderBy(a => a.NAME).ToList();
                List<RMDB_WARDS_WITH_CAN_ASSIGN> wards = db.RMDB_WARDS_WITH_CAN_ASSIGN.Where(a => a.WARDS_WHICH_CAN_ASSIGN_ID == viewModel.PatientMovement.WARD_LOCATION_ID).ToList();
                viewModel.Beds = new List<ROOM_BED>();
                foreach (RMDB_WARDS_WITH_CAN_ASSIGN ward in wards)
                {
                    ROOM_BED roombed = db.ROOM_BED.Where(a => a.IEN == ward.ROOM_BED_ID).FirstOrDefault();
                    if (roombed != null)
                        viewModel.Beds.Add(roombed);
                }
                viewModel.Beds = viewModel.Beds.OrderBy(a => a.NAME).ToList();

            }
        }

        #region Private Methods

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {

            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {

                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }

        #endregion

    }
}
